DROP PROCEDURE [dbo].[P_SIMULAR_COMISSAO]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[P_SIMULAR_COMISSAO] (
	@CD_EMP INT
	,@CD_FILIAL INT
	,@CD_PROD INT
	,@QTDE_PROD INT
	,@CD_FUN INT
	,@FLAG_PRE_VENCIDOS INT
	,@DATA_VENDA DATETIME
	,@ExibeHistorico BIT = 0
	,@PERC_DESC MONEY
	,@PERC_DESC_CAD MONEY
	,@SimulacaoPadrao BIT = 0
	)
AS
BEGIN
	SET NOCOUNT ON;

	SELECT *
	INTO #Comissoes
	FROM (
		SELECT cd_prod
			,cd_tbl_comis_perc
			,tp_nivel_perc
			,perc_comis
			,ds_comis_perc
			,ds_comis_vlr
			,vlr_comis
			,'COMISSAO NORMAL' AS DS_TIPO_COMIS
			,0 AS TIPO_COMIS
		FROM Ufd_est_prod_comis(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_FUN, @FLAG_PRE_VENCIDOS)
		
		UNION ALL
		
		SELECT cd_prod
			,cd_tbl_comis_perc
			,tp_nivel_perc
			,perc_comis
			,ds_comis_perc
			,ds_comis_vlr
			,Isnull(vlr_comis, 0)
			,'COMISSAO QUANTIDADE'
			,1
		FROM Ufd_est_prod_comis_qtde(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_FUN, @QTDE_PROD)
		
		UNION ALL
		
		SELECT cd_prod
			,Isnull(cd_tbl_comis_perc, 0)
			,Isnull(tp_nivel_perc, 0)
			,Isnull(perc_comis, 0)
			,ds_comis_perc
			,ds_comis_vlr
			,vlr_comis
			,'COMISSAO REGRESSAO'
			,2
		FROM Ufd_est_prod_comis_regressao(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_FUN, @PERC_DESC, @PERC_DESC_CAD) --regresso
		) Comis

	IF @ExibeHistorico = 1
	BEGIN
		INSERT INTO #Comissoes
		SELECT *
		FROM (
			SELECT cd_prod
				,cd_tbl_comis_perc
				,tp_nivel_perc
				,perc_comis
				,ds_comis_perc
				,ds_comis_vlr
				,vlr_comis
				,'COMISSAO NORMAL' AS DS_TIPO_COMIS
				,- 3 AS TIPO_COMIS
			FROM Ufd_est_prod_comis_historico(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_FUN, @FLAG_PRE_VENCIDOS, @DATA_VENDA)
			
			UNION ALL
			
			SELECT cd_prod
				,cd_tbl_comis_perc
				,tp_nivel_perc
				,perc_comis
				,ds_comis_perc
				,ds_comis_vlr
				,Isnull(vlr_comis, 0)
				,'COMISSAO QUANTIDADE'
				,- 2
			FROM Ufd_est_prod_comis_qtde_historico(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_FUN, @QTDE_PROD, @DATA_VENDA)
			
			UNION ALL
			
			SELECT cd_prod
				,Isnull(cd_tbl_comis_perc, 0)
				,Isnull(tp_nivel_perc, 0)
				,Isnull(perc_comis, 0)
				,ds_comis_perc
				,ds_comis_vlr
				,vlr_comis
				,'COMISSAO REGRESSAO'
				,- 1
			FROM Ufd_est_prod_comis_regressao_historico(@CD_EMP, @CD_FILIAL, @CD_PROD, @CD_FUN, @PERC_DESC, @PERC_DESC_CAD, @DATA_VENDA)
			) COMISHistorico
	END

	IF @SimulacaoPadrao = 1
	BEGIN
		SELECT cd_prod
			,cd_tbl_comis_perc
			,tp_nivel_perc
			,perc_comis
			,ds_comis_perc
			,ds_comis_vlr
			,vlr_comis
			,DS_TIPO_COMIS
			,TIPO_COMIS
		FROM (
			SELECT ROW_NUMBER() OVER (
					ORDER BY TIPO_COMIS DESC
					) AS RN
				,*
			FROM #Comissoes
			WHERE TIPO_COMIS >= 0
			
			UNION
			
			SELECT ROW_NUMBER() OVER (
					ORDER BY TIPO_COMIS DESC
					) AS RN
				,*
			FROM #Comissoes
			WHERE TIPO_COMIS < 0
			) Q
	END
	ELSE
	BEGIN
		SELECT cd_prod
			,cd_tbl_comis_perc
			,tp_nivel_perc
			,perc_comis
			,ds_comis_perc
			,ds_comis_vlr
			,vlr_comis
			,DS_TIPO_COMIS
			,TIPO_COMIS
		FROM (
			SELECT ROW_NUMBER() OVER (
					ORDER BY TIPO_COMIS DESC
					) AS RN
				,*
			FROM #Comissoes
			WHERE TIPO_COMIS >= 0
			
			UNION
			
			SELECT ROW_NUMBER() OVER (
					ORDER BY TIPO_COMIS DESC
					) AS RN
				,*
			FROM #Comissoes
			WHERE TIPO_COMIS < 0
			) Q
		WHERE RN = 1
	END
END
GO


